package gov.va.med.mhv.sm.web.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Locale;

import org.apache.commons.lang.StringUtils;

import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.foundation.service.response.messages.Message;
import gov.va.med.mhv.sm.model.Clinician;
import gov.va.med.mhv.sm.model.Facility;
import gov.va.med.mhv.sm.model.Surrogate;
import gov.va.med.mhv.sm.model.TriageGroup;
import gov.va.med.mhv.sm.model.User;

public class EditTriageGroup extends AbstractTriageGroupAction {
	
	

	public String start() {
		clearTriageGroup();
		return SUCCESS;
	}

	public String chooseName() {
		if ( cancelButtonPressed()) {
			return "CANCEL";
		}
		String name = getParameter("groupName");
		name = name.trim();
		ServiceResponse<TriageGroup> tgResp = getTriageGroupService().findActiveTriageGroupByName(name);  // Find only the Active triage group with that name
		if ( tgResp.getMessages().hasErrorMessages() ) {
			for(Object o : tgResp.getMessages().getErrorMessages() ) {
				Message m = (Message)o;
				for(Object insert : m.getInserts() ) {
					this.addActionError(insert.toString());
				}
			}
			return "FAILURE";
		}
		TriageGroup tg = tgResp.getPayload();
		setTriageGroup(tg);
		String station = tg.getVistaDiv();
		Facility f = getFacilityService().getFacilityByStationNumber(station).getPayload();
		setFacility(f);
		this.setVisnId(f.getVisnId());
		return SUCCESS;
	}

	public String goBack() {
		String step = getParameter("step");
		if ( ! StringUtils.isBlank(step) ) {
			return "STEP" + step;
		} else {
			return "STEP1";
		}
	}

	public String editTriageGroup() {
		if ( cancelButtonPressed() ) {
			return "CANCEL";
		}

		String newName = getParameter("newName");
		newName = newName.trim();
		String result = SUCCESS;

		//	Validate Triage group only while save the group not while delete triage group.(Bug#5128).
		if(StringUtils.isBlank(this.getParameter("delete")))
		{
			if (!getTriageGroup().getName().equalsIgnoreCase(newName) )
			{
				if(validTriageGroupName(newName) )
				{
					getTriageGroup().setName(newName);
					setSessionAttribute("TRIAGE_GROUP_NAME", getTriageGroup().getName());
				}
				else
				{
					return "INPUT";
				}
			}
			else{
				getTriageGroup().setName(newName);
			}
		}
		if ( ! StringUtils.isBlank(this.getParameter("add"))
				|| ! StringUtils.isBlank(this.getParameter("remove")) )
		{
			String clinicianResult = updateTriageClinicians();
			if ( SUCCESS.equals(clinicianResult) )
			{
				result = "INPUT";
		    }
		} else if ( ! StringUtils.isBlank(this.getParameter("addProviderRelation"))
				|| ! StringUtils.isBlank(this.getParameter("addClinicRelation"))
				|| ! StringUtils.isBlank(this.getParameter("addTeamRelation"))
				|| ! StringUtils.isBlank(this.getParameter("addPatientRelation")) )
		{
			result = addTriageRelations();
		} else if ( ! StringUtils.isBlank(this.getParameter("save")) )
		{
			setSessionAttribute("saveType","savePatientTriageMap");	// This session Attribute will set only when the user click the SaveGroup in the UI.
			if ( ! saveTriageGroup() ) {

				return "INPUT";
			}
		} else if ( ! StringUtils.isBlank(this.getParameter("delete")) ) {
			if ( ! safeToDelete() ) {
				return "CANT_DELETE";
			}
			getTriageGroup().setActive(false);
			if ( ! saveTriageGroup() ) {
				return "INPUT";
			}
			this.removeSessionAttribute("TRIAGE_GROUP_NAME");
		}
		return result;
	}
	private boolean safeToDelete() {
		return passesSurrogateDeleteRule() & passesCompletedMsgsRule();
	}

	private boolean passesSurrogateDeleteRule() {
		boolean result = true;
		// Check if the group is a surrogate

		Collection<Surrogate> surrogateList = getTriageGroupService().getCliniciansWithSurrogate(getTriageGroup()).getCollection();

		if ( ! surrogateList.isEmpty() ) {
			result = false;
			StringBuilder names = new StringBuilder();
			if ( surrogateList.size() == 1) {
				Surrogate surrogate = surrogateList.iterator().next();
				Clinician c = getUserDao().findClinicianById(surrogate.getSmsUser().getId());
				names.append(c.getFirstName()).append(" ").append(c.getLastName());
			} else {
				List<Surrogate> triageSurrogateList = new ArrayList<Surrogate>(surrogateList);
				for(int i = 0; i < triageSurrogateList.size(); i++) {
					Surrogate surrogate = triageSurrogateList.get(i);
					Clinician c1 = getUserDao().findClinicianById(surrogate.getSmsUser().getId());
					names.append(c1.getFirstName()).append(" ").append(c1.getLastName());
					if ( i < triageSurrogateList.size() - 2 ) {
						names.append(", ");
					} else if ( i == triageSurrogateList.size() - 2 ) {
						names.append(" and ");
					}
				}
			}
			StringBuilder message = new StringBuilder();
			message.append("This triage group cannot be deleted because it is a surrogate for ")
				.append(names)
				.append(".  Please contact ")
				.append(names);
			if ( surrogateList.size() == 1) {
				message.append(" to have this surrogate assignment removed before the group can be deleted.");
			} else {
				message.append(" to have these surrogate assignments removed before the group can be deleted.");
			}
			addTriageDeletionError(message.toString());
		}
		return result;
	}

	private boolean passesCompletedMsgsRule() {
		boolean result = true;
		// Check if the group has open messages
		Collection<gov.va.med.mhv.sm.model.Message> msgs = getTriageGroupService()
			.getOpenMsgsForTriageGroup(getTriageGroup()).getCollection();

		if ( ! msgs.isEmpty() ) {
			result = false;
			StringBuilder message = new StringBuilder();
			message.append("This triage group cannot be deleted because there are ")
				.append("<strong>"+msgs.size()+"</strong>")
				.append(" message");
			if ( msgs.size() > 1) {
				message.append("s");
			}
			message.append(" that have not been completed.  Select another triage group member to reassign the ")
				.append("<strong>"+msgs.size()+"</strong>")
				.append(msgs.size() > 1 ? " messages" : " message")
				.append(" that need to be completed.");
			addTriageDeletionError(message.toString());
			getServletRequest().setAttribute("REASSIGNCLINICIANS", getTriageGroup().getClinicians());
			getSession().setAttribute("messagesList", msgs);

			StringBuffer sb = new StringBuffer();
			for( gov.va.med.mhv.sm.model.Message m: msgs) {
				sb.append(m.getId()+" ");
			}
			getServletRequest().setAttribute("NotCompletedMsgs", sb.toString());
		}
		return result;
	}


	@SuppressWarnings("unchecked")
	private void addTriageDeletionError(String err) {
		List<String> errors = (List)getServletRequest().getAttribute("TRIAGE_DELETE_ERROR");
		if ( errors == null ) {
			errors = new ArrayList<String>();
			getServletRequest().setAttribute("TRIAGE_DELETE_ERROR", errors);
		}
		errors.add(err);
	}

	public static final Comparator<TriageGroup> TRIAGE_NAME_SORTER = new Comparator<TriageGroup>() {
		public int compare(TriageGroup a, TriageGroup b) {
			if(a == null || b == null) return 0;
			int result = (a.getName().toUpperCase()).compareTo(b.getName().toUpperCase());
			if ( result == 0 ) {
				result = a.getName().toUpperCase().compareTo(b.getName().toUpperCase());
			}
			return result;
		}
	};

	public Collection<TriageGroup> getManagedTriageGroups() {
		Locale.setDefault(Locale.ENGLISH);
		Facility f = getFacility();
		if ( f != null ) {
			//Implemented TRIAGE_NAME_SORTER for CQ: 5500
			Collection<TriageGroup> result = new TreeSet<TriageGroup>(TRIAGE_NAME_SORTER);
			result.addAll(getTriageGroupService().getTriageGroupsForStation(f.getStationNumber()).getCollection());
			return result;
		} else {
			addActionError("You must choose a facility");
			return new ArrayList<TriageGroup>();
		}
	}

	@Override
	protected String getFunction() {
		return AbstractTriageGroupAction.EDIT_FUNCTION;
	}

}
